<?php
require '../files/config.php';
require '../files/jwt.php';

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$action = $_GET['action'];
$secretKey = 'rZFQgpA6Lfs2SrBVgEh7EAWEZknYs75GGdCUW0mC7G0WS9JWVa9cRq';

switch ($action) {
    case 'register':
        register();
        break;
    case 'login':
        login();
        break;
    case 'logout':
        logout();
        break;
    default:
        echo json_encode(['message' => 'Invalid action']);
}

function validate_input($data) {
    return htmlspecialchars(strip_tags($data));
}

function register() {
    global $secretKey;
    $data = json_decode(file_get_contents("php://input"));

    if (!isset($data->username) || !isset($data->password) || !isset($data->email)) {
        echo json_encode(['message' => 'Invalid input']);
        return;
    }

    $username = validate_input($data->username);
    $password = validate_input($data->password);
    $email = validate_input($data->email);

    // Eingabedaten validieren
    if (empty($username) || empty($password) || empty($email)) {
        echo json_encode(['message' => 'Invalid input']);
        return;
    }

    $hashed_password = password_hash($password, PASSWORD_BCRYPT);

    $connection = connect();

    // Überprüfen, ob der Benutzername oder die E-Mail bereits existiert
    $stmt = $connection->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $username, $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo json_encode(['message' => 'User already exists']);
        $stmt->close();
        $connection->close();
        return;
    }

    $stmt->close();

    // Benutzer registrieren
    $stmt = $connection->prepare("INSERT INTO users (username, password, email) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $username, $hashed_password, $email);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'User registered successfully']);
    } else {
        echo json_encode(['message' => 'User registration failed']);
    }

    $stmt->close();
    $connection->close();
}

function login() {
    global $secretKey;
    $data = json_decode(file_get_contents("php://input"));

    if (!isset($data->username) || !isset($data->password)) {
        echo json_encode(['message' => 'Invalid input']);
        return;
    }

    $username = validate_input($data->username);
    $password = validate_input($data->password);

    // Eingabedaten validieren
    if (empty($username) || empty($password)) {
        echo json_encode(['message' => 'Invalid input']);
        return;
    }

    $connection = connect();

    $stmt = $connection->prepare("SELECT id, password FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->store_result();
    $stmt->bind_result($id, $hashed_password);

    if ($stmt->fetch() && password_verify($password, $hashed_password)) {
        $payload = [
            'iss' => "dersky.bplaced.net",
            'aud' => "dersky.bplaced.net",
            'iat' => time(),
            'nbf' => time(),
            'exp' => time() + (60*60), // Token valid for 1 hour
            'data' => [
                'id' => $id
            ]
        ];
        $token = generateJWT($payload, $secretKey);
        updateToken($id, $token);
        echo json_encode(['message' => 'Login successful', 'token' => $token]);
    } else {
        echo json_encode(['message' => 'Login failed']);
    }

    $stmt->close();
    $connection->close();
}

function logout() {
    $data = json_decode(file_get_contents("php://input"));
    $token = validate_input($data->token);

    // Token validieren
    if (empty($token)) {
        echo json_encode(['message' => 'Invalid input']);
        return;
    }

    $connection = connect();

    $stmt = $connection->prepare("UPDATE users SET token = NULL WHERE token = ?");
    $stmt->bind_param("s", $token);

    if ($stmt->execute()) {
        echo json_encode(['message' => 'Logout successful']);
    } else {
        echo json_encode(['message' => 'Logout failed']);
    }

    $stmt->close();
    $connection->close();
}




function updateToken($user_id, $token) {
    $connection = connect();
    $stmt = $connection->prepare("UPDATE users SET token = ? WHERE id = ?");
    $stmt->bind_param("si", $token, $user_id);
    $stmt->execute();
    $stmt->close();
    $connection->close();
}
?>
