<?php
function base64UrlEncode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64UrlDecode($data) {
    return base64_decode(strtr($data, '-_', '+/'));
}

function generateJWT($payload, $secretKey) {
    $header = base64UrlEncode(json_encode(['typ' => 'JWT', 'alg' => 'HS256']));
    $payload = base64UrlEncode(json_encode($payload));
    $signature = base64UrlEncode(hash_hmac('sha256', "$header.$payload", $secretKey, true));
    return "$header.$payload.$signature";
}

function validateJWT($jwt, $secretKey) {
    list($header, $payload, $signature) = explode('.', $jwt);
    $validSignature = base64UrlEncode(hash_hmac('sha256', "$header.$payload", $secretKey, true));
    if ($signature === $validSignature) {
        return json_decode(base64UrlDecode($payload), true);
    } else {
        return false;
    }
}
?>
